<?php

namespace UtillzCore\Inc\Src\Listing;

use \UtillzCore\Inc\Src\Form\Component as Form;

class Related {

    public $id;
    public $listing_type_id;
    public $taxonomy;
    public $terms;
    public $posts_per_page;

    function __construct( $id ) {

        $this->id = $id;
        $this->listing_type_id = (int) Ucore()->get( 'ulz_listing_type', $id );
        $this->taxonomy = Ucore()->prefix( Ucore()->get( 'ulz_related_taxonomy', $this->listing_type_id ) );
        $this->terms = Ucore()->get( $this->taxonomy, $id, false );
        $this->posts_per_page = 3;

    }

    public function set_posts_per_page( $num ) {
        $this->posts_per_page = (int) $num;
    }

    public function query() {

        global $ulz_nearby_post_ids;

        $args = [
            'post_type' => 'ulz_listing',
            'post_status' => 'publish',
            'posts_per_page' => $this->posts_per_page,
            'meta_query' => [
                'relation' => 'AND',
                [
                    'key' => 'ulz_listing_type',
                    'value' => $this->listing_type_id,
                    'compare' => '=',
                ],
                [
                    'key' => $this->taxonomy,
                    'value' => $this->terms,
                    'compare' => 'IN',
                ]
            ]
        ];

        $exclude = [ $this->id ];

        if( $ulz_nearby_post_ids && is_array( $ulz_nearby_post_ids ) ) {
            $exclude = array_merge( $exclude, $ulz_nearby_post_ids );
        }

        $args['post__not_in'] = $exclude;

        $query = new \WP_Query( $args );

        return $query;

    }

}
